/* - MotorControl full -
 * This example demonstrates the basic usage of a Phidget MotorControl.  It 
 * demonstrates the manipulation of the velocity, acceleration, and braking of the motor,
 * as well as displays the data from generated events.
 *
 * Please note that this example was designed to work with only one Phidget 
 * MotorControl connected.
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package MotorControl;

import com.phidgets.MotorControlPhidget;
import com.phidgets.PhidgetException;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import listeners.*;

public class MotorControl extends javax.swing.JFrame {

    private static String runArgs[];
    private MotorControlPhidget mc;
    private MCAttachListener attach_listener;
    private MCDetachListener detach_listener;
    private MCErrorListener error_listener;
    //private MCCurrentChangeListener current_listener;
    private MCCurrentUpdateListener current_listener;
    private MCInputChangeListener input_listener;
    private MCVelocityChangeListener velocity_listener;
    private MCBackEMFUpdateListener backEMF_listener;
    private MCSensorUpdateListener sensor_listener;
    private MCEncoderPositionChangeListener encoder_listener;
    //private MCEncoderPositionUpdateListener encoder_listener;
    private JCheckBox inputArray[];
    private JLabel sensorLabel[];
    private JTextField sensorArray[];
    private JLabel encoderLabel[];
    private JTextField encoderArray[];
    private JPanel inputPanel;
    private JPanel sensorPanel;
    private JPanel encoderPanel;

    /** Creates new form MotorControl */
    public MotorControl() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        numMotorsTxt = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        numInTxt = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        jLabel15 = new javax.swing.JLabel();
        numEncodersTxt = new javax.swing.JTextField();
        numSensorsTxt = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        motorCmb = new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        tarVelTxt = new javax.swing.JTextField();
        maxVelTxt = new javax.swing.JTextField();
        accelTxt = new javax.swing.JTextField();
        currentTxt = new javax.swing.JTextField();
        maxVelScrl = new javax.swing.JSlider();
        accelScrl = new javax.swing.JSlider();
        jLabel16 = new javax.swing.JLabel();
        brakeTxt = new javax.swing.JTextField();
        backEMFChk = new javax.swing.JCheckBox();
        jLabel17 = new javax.swing.JLabel();
        backEMFTxt = new javax.swing.JTextField();
        jLabel18 = new javax.swing.JLabel();
        supplyVoltageTxt = new javax.swing.JTextField();
        jLabel19 = new javax.swing.JLabel();
        brakeScrl = new javax.swing.JSlider();
        jPanel3 = new javax.swing.JPanel();
        in0Chk = new javax.swing.JCheckBox();
        in1Chk = new javax.swing.JCheckBox();
        in2Chk = new javax.swing.JCheckBox();
        in3Chk = new javax.swing.JCheckBox();
        jPanel4 = new javax.swing.JPanel();
        jLabel20 = new javax.swing.JLabel();
        sensorValTxt0 = new javax.swing.JTextField();
        jLabel21 = new javax.swing.JLabel();
        sensorValTxt1 = new javax.swing.JTextField();
        ratiometricChk = new javax.swing.JCheckBox();
        jPanel5 = new javax.swing.JPanel();
        jLabel22 = new javax.swing.JLabel();
        encoderTxt0 = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("MotorControl - full");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("MotorControl Info"));
        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        attachedTxt.setEditable(false);
        jPanel1.add(attachedTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 33, 200, -1));

        jLabel1.setText("Attached:");
        jPanel1.add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(43, 36, -1, -1));

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        nameTxt.setPreferredSize(new java.awt.Dimension(200, 58));
        jScrollPane1.setViewportView(nameTxt);

        jPanel1.add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 68, 200, -1));

        jLabel2.setText("Name:");
        jPanel1.add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 68, -1, -1));

        serialTxt.setEditable(false);
        jPanel1.add(serialTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 144, 200, -1));

        jLabel3.setText("Serial No:");
        jPanel1.add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(41, 147, -1, -1));

        versionTxt.setEditable(false);
        jPanel1.add(versionTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 180, 200, -1));

        jLabel4.setText("Version:");
        jPanel1.add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(48, 180, -1, -1));

        numMotorsTxt.setEditable(false);
        jPanel1.add(numMotorsTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 216, 65, -1));

        jLabel5.setText("Motors:");
        jPanel1.add(jLabel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(52, 216, -1, -1));

        numInTxt.setEditable(false);
        jPanel1.add(numInTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 252, 65, -1));

        jLabel13.setText("Inputs:");
        jPanel1.add(jLabel13, new org.netbeans.lib.awtextra.AbsoluteConstraints(54, 252, -1, -1));

        jLabel14.setText("Encoders:");
        jPanel1.add(jLabel14, new org.netbeans.lib.awtextra.AbsoluteConstraints(171, 216, -1, -1));

        jLabel15.setText("Sensors:");
        jPanel1.add(jLabel15, new org.netbeans.lib.awtextra.AbsoluteConstraints(178, 252, -1, -1));

        numEncodersTxt.setEditable(false);
        jPanel1.add(numEncodersTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(232, 216, 65, -1));

        numSensorsTxt.setEditable(false);
        jPanel1.add(numSensorsTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(232, 250, 65, -1));

        getContentPane().add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 11, 330, 290));

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Motor Data"));
        jPanel2.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        motorCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                motorCmbActionPerformed(evt);
            }
        });
        jPanel2.add(motorCmb, new org.netbeans.lib.awtextra.AbsoluteConstraints(107, 30, 190, -1));

        jLabel6.setText("Choose Motor:");
        jPanel2.add(jLabel6, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 33, -1, -1));

        jLabel7.setText("Target Velocity:");
        jPanel2.add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(14, 73, 90, -1));

        jLabel8.setText("Current Velocity:");
        jPanel2.add(jLabel8, new org.netbeans.lib.awtextra.AbsoluteConstraints(9, 110, -1, -1));

        jLabel9.setText("Acceleration:");
        jPanel2.add(jLabel9, new org.netbeans.lib.awtextra.AbsoluteConstraints(28, 140, -1, -1));

        jLabel10.setText("Current:");
        jPanel2.add(jLabel10, new org.netbeans.lib.awtextra.AbsoluteConstraints(170, 73, -1, -1));

        jLabel11.setText(" Velocity:");
        jPanel2.add(jLabel11, new org.netbeans.lib.awtextra.AbsoluteConstraints(53, 214, -1, -1));

        jLabel12.setText(" Acceleration:");
        jPanel2.add(jLabel12, new org.netbeans.lib.awtextra.AbsoluteConstraints(27, 249, -1, -1));

        tarVelTxt.setEditable(false);
        jPanel2.add(tarVelTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(107, 70, 60, -1));

        maxVelTxt.setEditable(false);
        jPanel2.add(maxVelTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(107, 105, 60, -1));

        accelTxt.setEditable(false);
        jPanel2.add(accelTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(107, 141, 60, -1));

        currentTxt.setEditable(false);
        jPanel2.add(currentTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(220, 70, 75, -1));

        maxVelScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                maxVelScrlStateChanged(evt);
            }
        });
        jPanel2.add(maxVelScrl, new org.netbeans.lib.awtextra.AbsoluteConstraints(107, 213, 190, -1));

        accelScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                accelScrlStateChanged(evt);
            }
        });
        jPanel2.add(accelScrl, new org.netbeans.lib.awtextra.AbsoluteConstraints(107, 249, 190, -1));

        jLabel16.setText("Braking:");
        jPanel2.add(jLabel16, new org.netbeans.lib.awtextra.AbsoluteConstraints(56, 180, -1, -1));

        brakeTxt.setEditable(false);
        jPanel2.add(brakeTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(107, 180, 60, -1));

        backEMFChk.setText("Back EMF Sensing");
        backEMFChk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                backEMFChkActionPerformed(evt);
            }
        });
        jPanel2.add(backEMFChk, new org.netbeans.lib.awtextra.AbsoluteConstraints(175, 105, -1, -1));

        jLabel17.setText("Back EMF:");
        jPanel2.add(jLabel17, new org.netbeans.lib.awtextra.AbsoluteConstraints(180, 141, -1, -1));

        backEMFTxt.setEditable(false);
        jPanel2.add(backEMFTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(240, 141, 56, -1));

        jLabel18.setText("Supply Voltage:");
        jPanel2.add(jLabel18, new org.netbeans.lib.awtextra.AbsoluteConstraints(170, 180, -1, -1));

        supplyVoltageTxt.setEditable(false);
        supplyVoltageTxt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                supplyVoltageTxtActionPerformed(evt);
            }
        });
        jPanel2.add(supplyVoltageTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(260, 180, 36, -1));

        jLabel19.setText(" Braking:");
        jPanel2.add(jLabel19, new org.netbeans.lib.awtextra.AbsoluteConstraints(53, 285, -1, -1));

        brakeScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                brakeScrlStateChanged(evt);
            }
        });
        jPanel2.add(brakeScrl, new org.netbeans.lib.awtextra.AbsoluteConstraints(107, 285, 190, -1));

        getContentPane().add(jPanel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 300, 330, 320));

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Input Data"));

        in0Chk.setText("Input 0");
        in0Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in0Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in1Chk.setText("Input 1");
        in1Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in1Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));
        in1Chk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                in1ChkActionPerformed(evt);
            }
        });

        in2Chk.setText("Input 2");
        in2Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in2Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in3Chk.setText("Input 3");
        in3Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in3Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(40, 40, 40)
                .add(in0Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in1Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in2Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in3Chk)
                .addContainerGap(44, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(in0Chk)
                    .add(in1Chk)
                    .add(in2Chk)
                    .add(in3Chk))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        getContentPane().add(jPanel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 620, 330, 60));

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Sensor Data"));
        jPanel4.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel20.setText("0");
        jPanel4.add(jLabel20, new org.netbeans.lib.awtextra.AbsoluteConstraints(15, 35, -1, -1));

        sensorValTxt0.setEditable(false);
        jPanel4.add(sensorValTxt0, new org.netbeans.lib.awtextra.AbsoluteConstraints(30, 32, 60, -1));

        jLabel21.setText("1");
        jPanel4.add(jLabel21, new org.netbeans.lib.awtextra.AbsoluteConstraints(100, 35, -1, -1));

        sensorValTxt1.setEditable(false);
        jPanel4.add(sensorValTxt1, new org.netbeans.lib.awtextra.AbsoluteConstraints(120, 32, 60, -1));

        ratiometricChk.setText("Ratiometric");
        ratiometricChk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ratiometricChkActionPerformed(evt);
            }
        });
        jPanel4.add(ratiometricChk, new org.netbeans.lib.awtextra.AbsoluteConstraints(200, 32, -1, -1));

        getContentPane().add(jPanel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 760, 330, 70));

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder("Encoder Data"));
        jPanel5.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel22.setText("Position:");
        jPanel5.add(jLabel22, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 36, -1, -1));

        encoderTxt0.setEditable(false);
        jPanel5.add(encoderTxt0, new org.netbeans.lib.awtextra.AbsoluteConstraints(63, 33, 60, -1));

        getContentPane().add(jPanel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 690, 330, 70));

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Initialize the MotorConrol object and hook the event listeners
     **/
    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened

        this.setSize(357, 670);

        inputArray = new JCheckBox[4];
        inputArray[0] = in0Chk;
        inputArray[1] = in1Chk;
        inputArray[2] = in2Chk;
        inputArray[3] = in3Chk;

        inputPanel = jPanel3;
        inputPanel.setVisible(false);
        for (int i = 0; i < 4; i++) {
            inputArray[i].setVisible(false);
            inputArray[i].setEnabled(false);
        }

        sensorPanel = jPanel4;
        sensorPanel.setVisible(false);
        sensorLabel = new JLabel[2];
        sensorLabel[0] = jLabel20;
        sensorLabel[1] = jLabel21;
        sensorArray = new JTextField[2];
        sensorArray[0] = sensorValTxt0;
        sensorArray[1] = sensorValTxt1;

        for (int i = 0; i < 2; i++) {
            sensorLabel[i].setVisible(false);
            sensorArray[i].setVisible(false);
            sensorArray[i].setEnabled(false);
        }

        ratiometricChk.setVisible(false);
        ratiometricChk.setEnabled(false);

        encoderPanel = jPanel5;
        encoderPanel.setVisible(false);
        encoderLabel = new JLabel[1];
        encoderLabel[0] = jLabel22;
        encoderArray = new JTextField[1];
        encoderArray[0] = encoderTxt0;

        for (int i = 0; i < 1; i++) {
            encoderLabel[i].setVisible(false);
            encoderArray[i].setVisible(false);
            encoderArray[i].setEnabled(false);
        }

        motorCmb.setEnabled(false);
        maxVelScrl.setEnabled(false);
        accelScrl.setEnabled(false);

        jLabel16.setEnabled(false);
        brakeTxt.setEnabled(false);

        jLabel19.setEnabled(false);
        brakeScrl.setEnabled(false);

        jLabel10.setEnabled(false);
        currentTxt.setEnabled(false);

        backEMFChk.setEnabled(false);
        jLabel17.setEnabled(false);
        backEMFTxt.setEnabled(false);

        jLabel18.setEnabled(false);
        supplyVoltageTxt.setEnabled(false);

        try {
            mc = new MotorControlPhidget();

            attach_listener = new MCAttachListener(this, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.numMotorsTxt, this.numInTxt,
                    this.numEncodersTxt, this.numSensorsTxt, this.tarVelTxt, this.maxVelTxt, this.accelTxt,
                    this.jLabel10, this.currentTxt, this.motorCmb, this.maxVelScrl,
                    this.accelScrl, this.brakeScrl, this.inputArray, this.brakeTxt, this.jLabel16,
                    this.supplyVoltageTxt, this.jLabel18, this.backEMFChk, this.backEMFTxt, this.jLabel17, this.sensorLabel, this.sensorArray,
                    this.encoderLabel, this.encoderArray, this.jLabel19, this.inputPanel, this.sensorPanel, this.encoderPanel, this.ratiometricChk);

            detach_listener = new MCDetachListener(this, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.numMotorsTxt, this.numInTxt,
                    this.numEncodersTxt, this.numSensorsTxt, this.tarVelTxt, this.maxVelTxt, this.accelTxt,
                    this.jLabel10, this.currentTxt, this.motorCmb, this.maxVelScrl,
                    this.accelScrl, this.brakeScrl, this.inputArray, this.brakeTxt, this.jLabel16,
                    this.supplyVoltageTxt, this.jLabel18, this.backEMFChk, this.backEMFTxt, this.jLabel17, this.sensorLabel, this.sensorArray,
                    this.encoderLabel, this.encoderArray, this.jLabel19, this.inputPanel, this.sensorPanel, this.encoderPanel, this.ratiometricChk);

            error_listener = new MCErrorListener(this);

            //current_listener = new MCCurrentChangeListener(this.currentTxt, this.motorCmb);
            current_listener = new MCCurrentUpdateListener(this.currentTxt, this.motorCmb);

            input_listener = new MCInputChangeListener(this.inputArray);

            velocity_listener = new MCVelocityChangeListener(this.mc, this, this.maxVelTxt, this.motorCmb);

            backEMF_listener = new MCBackEMFUpdateListener(this.backEMFTxt, this.backEMFChk, this.motorCmb);

            sensor_listener = new MCSensorUpdateListener(this.sensorArray, this.motorCmb);

            encoder_listener = new MCEncoderPositionChangeListener(this.encoderArray, this.motorCmb);
            //  encoder_listener = new MCEncoderPositionUpdateListener(this.encoderArray, this.motorCmb);

            mc.addAttachListener(attach_listener);
            mc.addDetachListener(detach_listener);
            mc.addErrorListener(error_listener);
            //mc.addCurrentChangeListener(current_listener);
            mc.addCurrentUpdateListener(current_listener);
            mc.addInputChangeListener(input_listener);
            mc.addMotorVelocityChangeListener(velocity_listener);
            mc.addBackEMFUpdateListener(backEMF_listener);
            mc.addSensorUpdateListener(sensor_listener);
            mc.addEncoderPositionChangeListener(encoder_listener);
            //mc.addEncoderPositionUpdateListener(encoder_listener);


            //This assumes that if there is a command line argument, it is a serial number
            //and we try to open that specific device. Otherwise, open any device.
            if ((runArgs.length > 1) && (runArgs[1].equals("remote"))) {
                mc.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                mc.open(Integer.parseInt(runArgs[0]));
            } else {
                mc.openAny();
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    /**
     * When a motor is selected, display its current velocity and acceleration data as well as the track bar controls
     **/
    private void motorCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_motorCmbActionPerformed

        if (motorCmb.isEnabled()) {
            try {
                maxVelScrl.setValue((int) mc.getVelocity(((Integer) motorCmb.getSelectedItem()).intValue()));
                tarVelTxt.setText(Integer.toString(maxVelScrl.getValue()));
                maxVelTxt.setText(Integer.toString(maxVelScrl.getValue()));
            } catch (PhidgetException ex) {
                maxVelScrl.setValue(0);
                tarVelTxt.setText("");
                maxVelTxt.setText(Integer.toString(maxVelScrl.getValue()));
            }

            try {
                accelScrl.setValue((int) mc.getAcceleration(((Integer) motorCmb.getSelectedItem()).intValue()));
                accelTxt.setText(Double.toString(mc.getAcceleration(((Integer) motorCmb.getSelectedItem()).intValue())));
            } catch (PhidgetException e) {
                accelScrl.setValue(accelScrl.getMinimum());
                accelTxt.setText(Integer.toString(accelScrl.getValue()));
            }

            if (currentTxt.isEnabled()) {
                try {
                    currentTxt.setText(Double.toString(mc.getCurrent(((Integer) motorCmb.getSelectedItem()).intValue())));
                } catch (PhidgetException e) {
                    currentTxt.setText("");
                }
            }

            if (backEMFChk.isEnabled()) {
                try {
                    backEMFChk.setSelected(mc.getBackEMFSensingState(((Integer) motorCmb.getSelectedItem()).intValue()));
                    if (backEMFChk.isSelected()) {
                        backEMFTxt.setText(Double.toString(((Integer) motorCmb.getSelectedItem()).intValue()));
                    }
                } catch (PhidgetException e) {
                    backEMFChk.setSelected(false);
                    backEMFTxt.setText("Unknown");
                }
            }

            if (brakeTxt.isEnabled()) {
                try {
                    brakeTxt.setText(Double.toString(mc.getBraking(((Integer) motorCmb.getSelectedItem()).intValue())));
                    brakeScrl.setValue((int) mc.getBraking(((Integer) motorCmb.getSelectedItem()).intValue()));
                } catch (PhidgetException e) {
                    brakeTxt.setText("");
                    brakeScrl.setValue(brakeScrl.getMinimum());
                }
            }

            if (supplyVoltageTxt.isEnabled()) {
                try {
                    supplyVoltageTxt.setText(Double.toString(mc.getSupplyVoltage()));
                } catch (PhidgetException e) {
                    supplyVoltageTxt.setText("");
                }
            }
        }


    }//GEN-LAST:event_motorCmbActionPerformed

    /**
     * When the velocity track bar is changed send this data to the motor control to affect the motor
     * If no motor control is attached, a PhidgetException will be thrown, so we 
     * will catch it and deal with it accordingly
     **/
    private void maxVelScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_maxVelScrlStateChanged
        if (maxVelScrl.isEnabled()) {
            try {
                mc.setVelocity(((Integer) motorCmb.getSelectedItem()).intValue(), maxVelScrl.getValue());
                //  maxVelTxt.setText(Integer.toString(maxVelScrl.getValue()));
                tarVelTxt.setText(Integer.toString(maxVelScrl.getValue()));
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
                attachedTxt.setText("false");
                nameTxt.setText("");
                serialTxt.setText("");
                versionTxt.setText("");
                numMotorsTxt.setText("");
                numInTxt.setText("");
                tarVelTxt.setText("");
                // maxVelTxt.setText("");
                accelTxt.setText("");

                jLabel10.setVisible(false);
                currentTxt.setText("");
                currentTxt.setVisible(false);

                motorCmb.setSelectedIndex(0);
                motorCmb.removeAllItems();
                motorCmb.setEnabled(false);

                int i;
                for (i = 0; i < 4; i++) {
                    inputArray[i].setVisible(false);
                }

                maxVelScrl.setEnabled(false);
                accelScrl.setEnabled(false);
            }

        }
    }//GEN-LAST:event_maxVelScrlStateChanged

    /**
     * When the acceleration track bar is changed send this data to the motor
     * control to affect the motor
     * If no motor control is attached, a PhidgetException will be thrown, so 
     * we will catch it and deal with it accordingly
     **/
    private void accelScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_accelScrlStateChanged
        if (accelScrl.isEnabled()) {
            try {
                mc.setAcceleration(((Integer) motorCmb.getSelectedItem()).intValue(), accelScrl.getValue());
                accelTxt.setText(Integer.toString(accelScrl.getValue()));
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
                attachedTxt.setText("false");
                nameTxt.setText("");
                serialTxt.setText("");
                versionTxt.setText("");
                numMotorsTxt.setText("");
                numInTxt.setText("");
                tarVelTxt.setText("");
                //maxVelTxt.setText("");
                accelTxt.setText("");

                jLabel10.setVisible(false);
                currentTxt.setText("");
                currentTxt.setVisible(false);

                motorCmb.setSelectedIndex(0);
                motorCmb.removeAllItems();
                motorCmb.setEnabled(false);

                int i;
                for (i = 0; i < 4; i++) {
                    inputArray[i].setVisible(false);
                }

                maxVelScrl.setEnabled(false);
                accelScrl.setEnabled(false);
            }
        }
    }//GEN-LAST:event_accelScrlStateChanged

    /**
     * When the form is being close, make sure to stop all the motors,
     * unhook the event listeners, and close the Phidget.
     **/
    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
    }//GEN-LAST:event_formWindowClosed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing

        try {
            //unhook the event listeners
            mc.removeMotorVelocityChangeListener(velocity_listener);
            mc.removeInputChangeListener(input_listener);
            //mc.removeCurrentChangeListener(current_listener);
            mc.removeCurrentUpdateListener(current_listener);
            mc.removeErrorListener(error_listener);
            mc.removeDetachListener(detach_listener);
            mc.removeAttachListener(attach_listener);
            mc.removeBackEMFUpdateListener(backEMF_listener);
            mc.removeSensorUpdateListener(sensor_listener);
            mc.removeEncoderPositionChangeListener(encoder_listener);
            //mc.removeEncoderPositionUpdateListener(encoder_listener);

            //stop the motors
            for (int i = 0; i < mc.getMotorCount(); i++) {
                mc.setVelocity(i, 0);
            }

            //close the motor control phidget
            mc.close();

            mc = null;

            dispose();
            System.exit(0);
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }//GEN-LAST:event_formWindowClosing

    private void brakeScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_brakeScrlStateChanged
        if (brakeScrl.isEnabled()) {
            try {
                mc.setBraking(((Integer) motorCmb.getSelectedItem()).intValue(), brakeScrl.getValue());
                brakeTxt.setText(Integer.toString(brakeScrl.getValue()));
            } catch (PhidgetException ex) {
            }
        }
    }//GEN-LAST:event_brakeScrlStateChanged

    private void backEMFChkStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_backEMFChkStateChanged
    }//GEN-LAST:event_backEMFChkStateChanged

    private void backEMFChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_backEMFChkActionPerformed

        JCheckBox outputChk = (JCheckBox) evt.getSource();

        try {
            if (outputChk.isEnabled()) {
                mc.setBackEMFSensingState(0, backEMFChk.isSelected());
                if (!backEMFChk.isSelected()) {
                    backEMFTxt.setText("Unknown");
                }
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }

    }//GEN-LAST:event_backEMFChkActionPerformed

    private void supplyVoltageTxtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_supplyVoltageTxtActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_supplyVoltageTxtActionPerformed

    private void ratiometricChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ratiometricChkActionPerformed
        JCheckBox chk = (JCheckBox) evt.getSource();

        try {
            if (chk.isEnabled()) {
                mc.setRatiometric(ratiometricChk.isSelected());
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_ratiometricChkActionPerformed

    private void in1ChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_in1ChkActionPerformed
    }//GEN-LAST:event_in1ChkActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new MotorControl().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSlider accelScrl;
    private javax.swing.JTextField accelTxt;
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JCheckBox backEMFChk;
    private javax.swing.JTextField backEMFTxt;
    private javax.swing.JSlider brakeScrl;
    private javax.swing.JTextField brakeTxt;
    private javax.swing.JTextField currentTxt;
    private javax.swing.JTextField encoderTxt0;
    private javax.swing.JCheckBox in0Chk;
    private javax.swing.JCheckBox in1Chk;
    private javax.swing.JCheckBox in2Chk;
    private javax.swing.JCheckBox in3Chk;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSlider maxVelScrl;
    private javax.swing.JTextField maxVelTxt;
    private javax.swing.JComboBox motorCmb;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField numEncodersTxt;
    private javax.swing.JTextField numInTxt;
    private javax.swing.JTextField numMotorsTxt;
    private javax.swing.JTextField numSensorsTxt;
    private javax.swing.JCheckBox ratiometricChk;
    private javax.swing.JTextField sensorValTxt0;
    private javax.swing.JTextField sensorValTxt1;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JTextField supplyVoltageTxt;
    private javax.swing.JTextField tarVelTxt;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
}
